//
//  NSURLCredential+RWPrivateKeyAdditions.h
//  RapidWeaver
//
//  Created by Keith Duncan on 22/05/2013.
//  Copyright (c) 2013 Realmac Software. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface RMFTPURLCredential : NSObject

@property (copy, nonatomic) NSString *user;
@property (copy, nonatomic) NSString *password;
@property (readonly, nonatomic) BOOL hasPassword;

@property (copy, nonatomic) NSURL *privateKeyLocation;

@property (copy, nonatomic) NSString *passphrase;
@property (copy, nonatomic) NSURL *localFolderURL;

@property (nonatomic) BOOL hasPrivateKey;
@property (nonatomic) BOOL isLocalFolderLocation;

+ (id)credentialWithUser:(NSString *)user password:(NSString *)password;

+ (id)credentialWithUser:(NSString *)user contentsOfPrivateKey:(NSURL *)privateKeyLocation passphrase:(NSString *)passphrase;
+ (id)credentialWithLocalFolderURL:(NSURL *)localFolderURL;

- (BOOL)startAccessingKeyFilesWithError:(NSError **)error;

@end
